/*
   Simple example of using the glm.h library
   to load an OBJ model into OpenGL.
*/
#include <windows.h>
#include "glm.h"

/* Prototype for the display callback function */
void display( void );

GLMmodel* pmodel = NULL;
char* pfile = NULL;

int main(int argc, char** argv)
{
   /* Standard GLUT initialization */
   glutInit(&argc,argv);
   glutInitDisplayMode (GLUT_SINGLE | GLUT_RGB | GLUT_DEPTH);
   glutInitWindowSize(500,500);    /* 500 x 500 pixel window */
   glutInitWindowPosition(50,50);  /* place window near top left of display */
   glutCreateWindow("OBJ Model");  /* window title */
   glutDisplayFunc(display);       /* display callback invoked when window opened */

   /* Initialize OpenGL state */
   glClearColor(1.0, 1.0, 1.0, 1.0); /* white background */
   glColor3f(1.0, 0.0, 0.0);         /* draw in red */

   glPolygonMode(GL_FRONT,GL_LINE);

   glEnable(GL_LIGHTING);
   glEnable(GL_LIGHT0);
   glEnable(GL_DEPTH_TEST);

   /* set up viewing */
   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   glOrtho(-2.0, 2.0, -2.0, 2.0, -2.0, 2.0); /* viewing volume */
   glMatrixMode(GL_MODELVIEW);
   gluLookAt(0, 0, 0, -5, 5, -5, 0, 1, 0);

   pfile = argv[1];

   /* Enter event loop */
   glutMainLoop();

   return 0;  /* we never get here */
}//main()


/* The display() callback function */
void display( void )
{
   glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);  /* clear the window */

   pmodel = glmReadOBJ(pfile);
   glmUnitize(pmodel);     // you don't have to call this (it just scales the model)
   glmFacetNormals(pmodel);
   glmVertexNormals(pmodel, 90.0);
   glmDraw(pmodel, GLM_SMOOTH);

   glFlush(); /* clear buffers */
}//display()
